Imports System
Imports System.Web
Imports System.Xml
Imports System.Text
Imports System.Web.UI
Imports System.Reflection
Imports System.Web.UI.WebControls
Imports System.Web.UI.HtmlControls

Partial Class VBASPXForm
  Inherits System.Web.UI.Page

  '//- Generated by PECTRA CnnManager - 2007
  '//- ---------------------------------------------------------
  '//- Page Date    : @<FormAttributes>PageDate</FormAttributes>
  '//- Page Version : @<FormAttributes>Version</FormAttributes>

#Region "[ - Public Members - ]"
  Public blnPreview As Boolean
  Public strFolderUpload As String
  Public sLastName, sFirstsName As String
  Public lngTrxId, lngInsId, lngTrxIdOrigen As Long
#End Region
#Region "[ - Private Members - ]"
  Private strErrDescription As String
  Private oUsrInt, oNodeUsr As Object
  Private blnActivityInitial As Boolean
  Private blnShowError As Boolean
  
  Private oAssembly As Assembly
  Private oInstance As Object
  Private oPectraOBPINETType As Type
  Private oResult As Object
#End Region
#Region "[ - DataSource and Attributes Declarations - ]"
  '---------------------------------------------------------------
  'DataSources
  '---------------------------------------------------------------
  '@<FormDataSources>Declare</FormDataSources>

  '---------------------------------------------------------------
  ' Form Attributes
  '---------------------------------------------------------------
  '@<FormAttributes>Declare</FormAttributes>
#End Region

#Region "[ - Custom Functions and Procedures - ]"
  '@<FormScript>SourceCode</FormScript>
#End Region

  Private Sub InitializeValues()
    '//-
    Try
      lngInsId = Request.QueryString("InsId")
      lngTrxId = Request.QueryString("TrxId")
      '//-Consulto si es la actividad inicial o no

      If CStr(InvokeOBPIMethod("AttributeGetValue", lngTrxId, "ActId")) = "1" Then
        blnActivityInitial = True
      Else
        blnActivityInitial = False
      End If
      '//-
      If (blnActivityInitial = True) Then
        'es un nombre aleatorio, de forma que sea nico (debido a que no existe en este momento un PngInsId
        strFolderUpload = lngTrxId
      Else
        'se le asigna el PngInsId a la carpeta en que se guardan los archivos
        strFolderUpload = CStr(InvokeOBPIMethod("AttributeGetValue", lngTrxId, "PngInsId"))
      End If
      '//-
      lngTrxIdOrigen = Request.QueryString("TrxIdOrigen")
      If IsNumeric(lngInsId) Then
        lngInsId = CLng(lngInsId)
      Else
        lngInsId = 0
      End If
      If IsNumeric(lngTrxIdOrigen) Then
        lngTrxIdOrigen = CLng(lngTrxIdOrigen)
      Else
        lngTrxIdOrigen = 0
      End If
      If IsNumeric(lngTrxId) Then
        lngTrxId = CLng(lngTrxId)
      Else
        lngTrxId = 0
      End If
      '//-
      blnPreview = True
      If Request.QueryString("Preview") = "1" Then blnPreview = False
      '//-
      '//- Si se est previsualizando...
      If blnPreview Then
        '//- Capturo el usuario logueado
        oUsrInt = CreateObject("UsrInterface.Engine")
        oNodeUsr = oUsrInt.GetOneUsrNode(CStr(InvokeOBPIMethod("AttributeGetValue", lngTrxId, "LoguedUsrId")))
        sFirstsName = oNodeUsr.SelectSingleNode("FirstName").text
        sLastName = oNodeUsr.SelectSingleNode("LastName").text
        oNodeUsr = Nothing
        oUsrInt = Nothing
      End If
      '//-
      '//- Inicio los dataSources, si es que se definieron
      If Not (IsPostBack) Then
        Try
          Dim oMethods As MethodInfo() = Me.GetType().GetMethods()
          Dim oMethod As MethodInfo
          For Each oMethod In oMethods
            If (oMethod.Name.StartsWith("InitializeDataSources") Or _
                oMethod.Name.StartsWith("InitializeCOMDataSources") Or _
                oMethod.Name.StartsWith("InitializeWSDataSources")) Then _
              oMethod.Invoke(Me, Nothing)
          Next
          oMethods = Nothing
        Catch
        End Try
      End If
      '//-
    Catch
      '//- Do Nothing
    End Try
  End Sub
  Private Sub InitializeAttributes()
    '@<FormAttributes>PreProcess</FormAttributes>
  End Sub

  Private Function EstandarizarXmlDb(ByVal objRs As Object) As String
    Dim i As Integer
    Dim strDataFieldContent As String
    Dim strXmlFillDb As String
    strDataFieldContent = ""
    strXmlFillDb = ""

    If Not objRs Is Nothing Then
      If Not (objRs.BOF And objRs.EOF) Then
        objRs.movefirst()
        Do While Not (objRs.EOF)
          For i = 0 To objRs.Fields.Count - 1
            strDataFieldContent = strDataFieldContent & "<" & objRs.Fields(i).Name & "><![CDATA[" & _
                   objRs.Fields(i).Value.ToString().Trim() & "]]></" & _
                   objRs.Fields(i).Name & ">"
          Next
          strXmlFillDb = strXmlFillDb & "<DataField>" & strDataFieldContent & "</DataField>"
          strDataFieldContent = ""
          objRs.movenext()
        Loop
        objRs.movefirst()
        Return "<Data>" & strXmlFillDb & "</Data>"
      End If
    End If
    '//-
    Return "<Data />"
  End Function
  Private Function EstandarizarXmlWs(ByVal oXml As Object) As String
    Dim oNodo As Object
    Dim oChild As Object
    Dim strNodeName As String
    Dim strDatos As String
    Dim oLastNode As Object
    Dim strXmlFillWs As String

    Try
      oNodo = oXml.documentElement
      oNodo = oNodo.childNodes(0)
      strNodeName = ""
      strDatos = ""
      strXmlFillWs = ""
      strNodeName = oNodo.nodeName
      For Each oChild In oXml.selectNodes("//" & strNodeName)
        For Each oLastNode In oChild.childNodes
          strDatos = strDatos & "<" & oLastNode.nodeName & "><![CDATA[" & Trim(oLastNode.text) & _
               "]]></" & oLastNode.nodeName & ">"
        Next
        strXmlFillWs = strXmlFillWs & "<DataField>" & strDatos & "</DataField>"
        strDatos = ""
      Next

      Return "<Data>" & strXmlFillWs & "</Data>"
    Catch ex As Exception
      Me.PrepareErrLog(ex)
      Return "<Data />"
    Finally
      oNodo = Nothing
      oChild = Nothing
      oLastNode = Nothing
    End Try
  End Function
  
  Protected Sub FillCombo(ByVal objDataSource As Object, ByVal strDataSourceField As String)
		If Not objDataSource Is Nothing Then
            If Not (objDataSource.EOF = True And objDataSource.BOF = True) Then
                objDataSource.MoveFirst()
                Do While Not objDataSource.EOF
                    response.write("<option value='" & objDataSource.Fields(strDataSourceField).Value & "'>" & objDataSource.Fields(strDataSourceField).Value & "</option>")
                    objDataSource.MoveNext()
                Loop
            End If
        End If
		
  End Sub

  Private Sub PrepareErrLog(ByVal ex As Exception)
    strErrDescription = "<span class=""font-family: Courier New; font-size: 10px;"">" & _
                        "Number      : " & Err.Number & "<br />" & _
                        "Description : " & ex.Message & "<br />" & _
                        "StackTrace  : " & ex.StackTrace & "<br />" & _
                        "Source      : " & Err.Source & "<br />" & _
                        "HelpFile    : " & Err.HelpFile & "<br />" & _
                        "HelpContext : " & Err.HelpContext & "</span>"
    '//-
    Call ShowConfirmMessage(strErrDescription)
  End Sub
  Private Sub ShowConfirmMessage(ByVal pszMessage As String)
    Dim oNewRow As HtmlTableRow
    Dim oNewCel As HtmlTableCell

    Try
      tblButtons.Rows.Clear()
      tblContent.Rows.Clear()
      '//-
      '//- Preparo los botones
      oNewRow = New HtmlTableRow()
      oNewRow.Attributes.Add("class", "Line")
      oNewRow.Cells.Add(New HtmlTableCell())
      oNewRow.Cells.Add(New HtmlTableCell())
      tblButtons.Rows.Add(oNewRow)
      '//-
      '//- Preparo el mensaje
      oNewRow = New HtmlTableRow()
      oNewRow.Attributes.Add("class", "Line")
      For i As Integer = 0 To 1
        oNewCel = New HtmlTableCell()
        oNewCel.Attributes.Add("class", "Value")
        If (i = 1) Then
          oNewCel.Attributes.Add("align", "left")
          oNewCel.InnerHtml = pszMessage
        Else
          oNewCel.InnerHtml = "&nbsp;"
        End If
        oNewRow.Cells.Add(oNewCel)
      Next
      tblContent.Rows.Add(oNewRow)
      '//-
    Catch ex As Exception
      Me.blnShowError = True
      PrepareErrLog(ex)
    Finally
      oNewCel = Nothing
      oNewRow = Nothing
      GC.Collect()
    End Try
  End Sub

  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    Me.blnShowError = False
    Try
	  '- Instancia la clase "Engine" del assembly "PectraOBPINET"
	  oAssembly = Assembly.LoadWithPartialName("PectraOBPINET")
	  oInstance = oAssembly.CreateInstance("PectraOBPINET.Engine")
	  oPectraOBPINETType = oInstance.GetType()
      '//-
      Call InitializeValues()
      If Not (IsPostBack) Then Call InitializeAttributes()
      '//-
    Catch ex As Exception
      Me.blnShowError = True
      PrepareErrLog(ex)
    Finally
      GC.Collect()
    End Try
  End Sub
  
  Public Function InvokeOBPIMethod(ByVal oName As String, ByVal ParamArray oParams() As Object) As Object
	Try
	    '- Invoca al metodo en cuestion
		Return oPectraOBPINETType.InvokeMember(oName, BindingFlags.InvokeMethod, Nothing, oInstance, oParams)
	Catch ex As Exception
      Me.blnShowError = True
      Throw
    Finally
      GC.Collect()
	End Try

  End Function

  Protected Sub btnOk_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnOk.Click
    Dim strSetAttributes As String = String.Empty
    ' ================================================
    '     OK
    ' ================================================
    Try
      ' Set Attributes
      '@<FormAttributes>GetData</FormAttributes>

      ' Set DataDestinations
      '@<FormDataDestinations>GetData</FormDataDestinations>

      ' Activity End
      InvokeOBPIMethod("ActivityEnd", lngTrxId, strSetAttributes)
      '//-
      '//- Ahora muestro el mensaje de confirmacin
      Call ShowConfirmMessage("Transaction Processed.")
    Catch ex As Exception
      Me.blnShowError = True
      Call PrepareErrLog(ex)
    Finally
      GC.Collect()
    End Try
  End Sub
  Protected Sub btnCancel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnCancel.Click
    ' ================================================
    '     CANCEL
    ' ================================================
    Try
      ' Unlock Instance
      InvokeOBPIMethod("InstanceLockUnLock", lngTrxId, False)
      ' Clean Pkg
      InvokeOBPIMethod("PackageDelOne", lngTrxId)
      '//-
      '//- Ahora muestro el mensaje de confirmacin
      If Not (Me.blnShowError) Then
        Call ShowConfirmMessage("Transaction Processed.")
      End If
    Catch ex As Exception
      Me.blnShowError = True
      Call PrepareErrLog(ex)
    Finally
      GC.Collect()
    End Try
  End Sub

End Class
